<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use App\Http\Resources\WholesalerResource;
use App\Models\Wholesaler;
use Illuminate\Http\Request;
use Illuminate\Http\JsonResponse;
use Illuminate\Http\Resources\Json\AnonymousResourceCollection;

class WholesalerController extends Controller
{
    /**
     * Display a listing of active wholesalers.
     */
    public function index(Request $request): AnonymousResourceCollection
    {
        $query = Wholesaler::query();

        // Only show active wholesalers by default
        if ($request->input('status', 'active') === 'active') {
            $query->active();
        } elseif ($request->has('status')) {
            $query->where('status', $request->status);
        }

        // Search by wholesaler name
        if ($request->has('search')) {
            $search = $request->search;
            $query->where('wholesaler_name', 'like', "%{$search}%");
        }

        // Sorting
        $sortField = $request->input('sort', 'wholesaler_name');
        $sortDirection = $request->input('direction', 'asc');
        $query->orderBy($sortField, $sortDirection);

        // Return all or paginated
        if ($request->has('per_page')) {
            $wholesalers = $query->paginate($request->per_page);
            return WholesalerResource::collection($wholesalers);
        }

        $wholesalers = $query->get();
        return WholesalerResource::collection($wholesalers);
    }

    /**
     * Display the specified wholesaler.
     */
    public function show(Wholesaler $wholesaler): JsonResponse
    {
        return response()->json([
            'success' => true,
            'data' => new WholesalerResource($wholesaler),
        ]);
    }
}
