<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class StorePharmacyWholesalerRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'pharmacy_id' => ['required', 'integer', 'exists:pharmacies,id'],
            'wholesaler_id' => ['required', 'integer', 'exists:wholesalers,id'],
            'account_number' => ['required', 'string', 'max:255'],
            'is_primary' => ['sometimes', 'boolean'],
            'status' => ['sometimes', 'in:active,inactive'],
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'pharmacy_id.required' => 'Pharmacy is required.',
            'pharmacy_id.exists' => 'Selected pharmacy does not exist.',
            'wholesaler_id.required' => 'Wholesaler is required.',
            'wholesaler_id.exists' => 'Selected wholesaler does not exist.',
            'account_number.required' => 'Account number is required.',
        ];
    }
}
