<?php

namespace App\Http\Requests;

use Illuminate\Foundation\Http\FormRequest;

class UpdateOrderRequest extends FormRequest
{
    /**
     * Determine if the user is authorized to make this request.
     */
    public function authorize(): bool
    {
        return auth()->check();
    }

    /**
     * Get the validation rules that apply to the request.
     *
     * @return array<string, \Illuminate\Contracts\Validation\ValidationRule|array<mixed>|string>
     */
    public function rules(): array
    {
        return [
            'pharmacy_id' => ['required', 'integer', 'exists:pharmacies,id'],
            'wholesaler_id' => ['required', 'integer', 'exists:wholesalers,id'],
            'wholesaler_account_number' => ['nullable', 'string', 'max:255'],
            'delivery_date' => ['nullable', 'date', 'after_or_equal:today'],
            'notes' => ['nullable', 'string', 'max:1000'],
            'items' => ['required', 'array', 'min:1'],
            'items.*.product_id' => ['required', 'integer', 'exists:products,id'],
            'items.*.quantity' => ['required', 'integer', 'min:1', 'max:9999'],
        ];
    }

    /**
     * Get custom messages for validator errors.
     *
     * @return array<string, string>
     */
    public function messages(): array
    {
        return [
            'pharmacy_id.required' => 'Pharmacy is required.',
            'pharmacy_id.exists' => 'Selected pharmacy does not exist.',
            'wholesaler_id.required' => 'Wholesaler is required.',
            'wholesaler_id.exists' => 'Selected wholesaler does not exist.',
            'delivery_date.after_or_equal' => 'Delivery date must be today or in the future.',
            'items.required' => 'Order must contain at least one item.',
            'items.min' => 'Order must contain at least one item.',
            'items.*.product_id.exists' => 'One or more products do not exist.',
            'items.*.quantity.required' => 'Quantity is required for all items.',
            'items.*.quantity.min' => 'Quantity must be at least 1.',
        ];
    }
}
