<?php

namespace App\Http\Resources;

use Illuminate\Http\Request;
use Illuminate\Http\Resources\Json\JsonResource;

class OrderResource extends JsonResource
{
    /**
     * Transform the resource into an array.
     *
     * @return array<string, mixed>
     */
    public function toArray(Request $request): array
    {
        return [
            'id' => $this->id,
            'company_id' => $this->company_id,
            'rep_id' => $this->rep_id,
            'pharmacy_id' => $this->pharmacy_id,
            'wholesaler_id' => $this->wholesaler_id,
            'wholesaler_account_number' => $this->wholesaler_account_number,
            'order_number' => $this->order_number,
            'delivery_date' => $this->delivery_date?->format('Y-m-d'),
            'total_items' => $this->total_items,
            'total_amount' => $this->total_amount,
            'status' => $this->status,
            'notes' => $this->notes,
            'processed_at' => $this->processed_at?->toISOString(),
            'rep' => $this->whenLoaded('rep', function () {
                return [
                    'id' => $this->rep->id,
                    'name' => $this->rep->name,
                    'email' => $this->rep->email,
                ];
            }),
            'pharmacy' => $this->whenLoaded('pharmacy', function () {
                return [
                    'id' => $this->pharmacy->id,
                    'pharmacy_name' => $this->pharmacy->pharmacy_name,
                    'phone' => $this->pharmacy->phone,
                    'email' => $this->pharmacy->email,
                    'delivery_address' => $this->pharmacy->delivery_address,
                ];
            }),
            'wholesaler' => $this->whenLoaded('wholesaler', function () {
                return [
                    'id' => $this->wholesaler->id,
                    'wholesaler_name' => $this->wholesaler->wholesaler_name,
                    'email' => $this->wholesaler->email,
                    'phone' => $this->wholesaler->phone,
                ];
            }),
            'items' => OrderItemResource::collection($this->whenLoaded('items')),
            'pdf' => new OrderPdfResource($this->whenLoaded('pdf')),
            'created_at' => $this->created_at?->toISOString(),
            'updated_at' => $this->updated_at?->toISOString(),
        ];
    }
}
