<?php

namespace App\Models;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;
use Illuminate\Database\Eloquent\Relations\BelongsToMany;
use Illuminate\Database\Eloquent\Relations\HasMany;

class Wholesaler extends Model
{
    use HasFactory;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'wholesaler_name',
        'contact_details',
        'email',
        'phone',
        'address',
        'status',
    ];

    /**
     * The attributes that should be cast.
     *
     * @var array<string, string>
     */
    protected $casts = [
        'contact_details' => 'array',
    ];

    /**
     * Get the pharmacies associated with the wholesaler.
     */
    public function pharmacies(): BelongsToMany
    {
        return $this->belongsToMany(Pharmacy::class, 'pharmacy_wholesaler_accounts')
            ->using(PharmacyWholesalerAccount::class)
            ->withPivot(['account_number', 'is_primary', 'status'])
            ->withTimestamps();
    }

    /**
     * Get the orders for the wholesaler.
     */
    public function orders(): HasMany
    {
        return $this->hasMany(Order::class);
    }

    /**
     * Scope a query to only include active wholesalers.
     */
    public function scopeActive($query)
    {
        return $query->where('status', 'active');
    }
}
