<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->foreignId('company_id')->nullable()->after('id')->constrained('companies')->onDelete('cascade');
            $table->enum('role', ['super_admin', 'company_admin', 'rep'])->default('rep')->after('company_id');
            $table->string('phone')->nullable()->after('email');
            $table->string('territory')->nullable()->after('phone');
            $table->enum('status', ['active', 'inactive'])->default('active')->after('territory');
            $table->timestamp('last_login_at')->nullable()->after('status');

            // Indexes
            $table->index('company_id');
            $table->index('role');
            $table->index('status');
            $table->index(['company_id', 'role']);
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::table('users', function (Blueprint $table) {
            $table->dropForeign(['company_id']);
            $table->dropIndex(['users_company_id_index']);
            $table->dropIndex(['users_role_index']);
            $table->dropIndex(['users_status_index']);
            $table->dropIndex(['users_company_id_role_index']);
            $table->dropColumn([
                'company_id',
                'role',
                'phone',
                'territory',
                'status',
                'last_login_at'
            ]);
        });
    }
};
