<?php

use Illuminate\Foundation\Application;
use Illuminate\Support\Facades\Route;
use Inertia\Inertia;

Route::get('/', function () {
    return Inertia::render('Welcome', [
        'canLogin' => Route::has('login'),
        'canRegister' => Route::has('register'),
        'laravelVersion' => Application::VERSION,
        'phpVersion' => PHP_VERSION,
    ]);
});

Route::middleware([
    'auth:sanctum',
    config('jetstream.auth_session'),
    'verified',
])->group(function () {
    Route::get('/dashboard', function () {
        return Inertia::render('Dashboard');
    })->name('dashboard');

    // Admin Routes
    Route::prefix('admin')->name('admin.')->group(function () {
        // Companies Management
        Route::resource('companies', \App\Http\Controllers\Admin\CompanyController::class);

        // Products & Brands Management
        Route::resource('products', \App\Http\Controllers\Admin\ProductController::class);
        Route::post('products/import', [\App\Http\Controllers\Admin\ProductController::class, 'import'])->name('products.import');
        Route::get('products/export', [\App\Http\Controllers\Admin\ProductController::class, 'export'])->name('products.export');

        // Wholesalers Management
        Route::resource('wholesalers', \App\Http\Controllers\Admin\WholesalerController::class);

        // Pharmacies Management
        Route::resource('pharmacies', \App\Http\Controllers\Admin\PharmacyController::class);

        // Reps Management
        Route::resource('reps', \App\Http\Controllers\Admin\RepController::class);

        // Orders Management
        Route::resource('orders', \App\Http\Controllers\Admin\OrderController::class);
        Route::get('orders/export', [\App\Http\Controllers\Admin\OrderController::class, 'export'])->name('orders.export');

        // Dashboard & Reports
        Route::get('dashboard', [\App\Http\Controllers\Admin\DashboardController::class, 'index'])->name('dashboard');
        Route::get('reports/sales', [\App\Http\Controllers\Admin\ReportController::class, 'sales'])->name('reports.sales');
        Route::get('reports/products', [\App\Http\Controllers\Admin\ReportController::class, 'products'])->name('reports.products');
        Route::get('reports/reps', [\App\Http\Controllers\Admin\ReportController::class, 'reps'])->name('reports.reps');
    });

    // Rep Routes (for field sales reps)
    Route::prefix('rep')->name('rep.')->group(function () {
        // Dashboard - shows list of pharmacies
        Route::get('dashboard', [\App\Http\Controllers\Rep\DashboardController::class, 'index'])->name('dashboard');

        // Orders
        Route::get('orders', [\App\Http\Controllers\Rep\OrderController::class, 'index'])->name('orders.index');
        Route::get('orders/create/{pharmacy}', [\App\Http\Controllers\Rep\OrderController::class, 'create'])->name('orders.create');
        Route::post('orders', [\App\Http\Controllers\Rep\OrderController::class, 'store'])->name('orders.store');
        Route::get('orders/{order}', [\App\Http\Controllers\Rep\OrderController::class, 'show'])->name('orders.show');
    });

    // Supplier Admin Routes (for company admins - read-only views)
    Route::prefix('supplier-admin')->name('supplier-admin.')->group(function () {
        // Dashboard - overview of supplier's business
        Route::get('dashboard', [\App\Http\Controllers\SupplierAdmin\DashboardController::class, 'index'])->name('dashboard');

        // Reps Management (Supplier admins manage their own reps)
        Route::resource('reps', \App\Http\Controllers\SupplierAdmin\RepController::class);

        // Products Management
        Route::resource('products', \App\Http\Controllers\SupplierAdmin\ProductController::class);
        Route::get('products-upload', [\App\Http\Controllers\SupplierAdmin\ProductController::class, 'upload'])->name('products.upload');
        Route::post('products-import', [\App\Http\Controllers\SupplierAdmin\ProductController::class, 'import'])->name('products.import');
        Route::get('products-export', [\App\Http\Controllers\SupplierAdmin\ProductController::class, 'export'])->name('products.export');

        // Orders - Read-only views of all orders from supplier's reps
        Route::get('orders', [\App\Http\Controllers\SupplierAdmin\OrderController::class, 'index'])->name('orders.index');
        Route::get('orders/{order}', [\App\Http\Controllers\SupplierAdmin\OrderController::class, 'show'])->name('orders.show');

        // Pharmacies - Read-only views of pharmacies created by supplier's reps
        Route::get('pharmacies', [\App\Http\Controllers\SupplierAdmin\PharmacyController::class, 'index'])->name('pharmacies.index');
        Route::get('pharmacies/{pharmacy}', [\App\Http\Controllers\SupplierAdmin\PharmacyController::class, 'show'])->name('pharmacies.show');

        // Wholesalers - Read-only list of wholesalers used by supplier's reps
        Route::get('wholesalers', [\App\Http\Controllers\SupplierAdmin\WholesalerController::class, 'index'])->name('wholesalers.index');
    });
});
